#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

struct trkac {
    int x, v;
};

bool uporediTrkace(const trkac& a, const trkac& b) {
    return a.x < b.x;
}

double vremeDoPreticanja(const trkac& a, const trkac& b) {
    return static_cast<double>(b.x - a.x) / (a.v - b.v);
}

int main() {
    int N, K;
    cin >> N >> K;

    vector<trkac> trkaci(N);
    for (int i = 0; i < N; ++i) {
        cin >> trkaci[i].x >> trkaci[i].v;
    }

    sort(trkaci.begin(), trkaci.end(), uporediTrkace);

    double time = 0.0;
    for (int i = 0; i < N - 1; ++i) {
        for (int j = i + 1; j < N; ++j) {
            if (--K == 0) {
                cout << fixed << time << endl;
                return 0;
            }
            time = max(time, vremeDoPreticanja(trkaci[i], trkaci[j]));
        }
    }

    return 0;
}